# Anki Remote

A simple [custom remote](https://www.unifiedremote.com/) for the spaced repetition flashcard app [Anki](http://ankisrs.net/). Review cards while on a treadmill or across the room!

## Screenshot

<img src="https://raw.githubusercontent.com/Glutanimate/unified-remote-anki/master/screen.png">

## Features

List of buttons, from top to bottom:

*First row*

* Launch Anki
* Go to Deck Overview
* Quit Anki (with confirmation dialog)

*Second row*

* Backspace
* Select deck
* Escape

*Third row*

The following features require the [Zoom](https://ankiweb.net/shared/info/1956318463) and [Toggle Full Screen](https://ankiweb.net/shared/info/1703043345) add-ons for Anki to be installed.

* Reset zoom
* Zoom in
* Zoom out
* Go fullscreen

*Fourth row*

* Move up
* Answer/Confirm selection
* Move down

*Fifth row*

* Apply rating: 1/2/3/4

*Sixth row*

* Repeat media playback
* Mark card
* Suspend note
* Undo

## Requirements

* Anki 2.0.x or 2.1.x
    - Please note that – due to key assignment changes – some of the features in this remote might not work with Anki 2.1. Unfortunately there is no good way to detect which version of Anki is running. As soon as 2.1 overtakes 2.0 in general use I will be updating the remote to reflect the new hotkey assignments.
* [Zoom](https://ankiweb.net/shared/info/1956318463) and [Toggle Full Screen](https://ankiweb.net/shared/info/1703043345) add-ons for Anki (optional)

## Changelog

* 2018-09-04: Added note on Anki 2.1 support
* 2016-05-14: Added support for OS X (thanks to @luminousspice!)
* 2016-05-08: Added more buttons; Restructured remote; Remote now asks for confirmation before exiting
* 2015-08-09: Initial release

## License

*Copyright (c) 2015-2018 [Glutanimate](https://glutanimate.com/)*

This project is licensed under the GNU GPLv3.

The icon is based on '[Anki icon for Faenza](http://jesuisbenjamin.deviantart.com/art/Anki-icon-for-Faenza-202232311)' by [jesuisbenjamin](http://jesuisbenjamin.deviantart.com/); released under the [CC BY-NC-SA 3.0](https://creativecommons.org/licenses/by-nc-sa/3.0/) license.

## Support my work

Writing, supporting, and maintaining open-source projects like this takes a lot of time and effort. If *Anki Remote* or any of my other Anki utilities has been a valuable asset in your studies, please consider **buying me a coffee**:

<a href="https://www.buymeacoffee.com/glutanimate" rel="nofollow"><img src="https://www.buymeacoffee.com/assets/img/custom_images/orange_img.png"></a>

Each and every contribution is greatly appreciated and will help me keep working on my projects!